#include "window.h"

#include <KAboutData>
#include <KLocalizedString>
#include <KDBusService>

#include <QApplication>
#include <QCommandLineParser>


const QString Dikt::AppName = "Dikt";
const QString Dikt::Version = "2v";

void Dikt::newInstance(const QStringList &args)
{
	QList<KMainWindow*> windowList = KMainWindow::memberList();
	Dict::Window *window = (windowList.isEmpty())
		? new Dict::Window() : (Dict::Window *)windowList.first();

	if (args.count())
		window->startup(args.last());
	else
		window->startup();
}

int main(int argc, char *argv[])
{
	QApplication app(argc, argv);
	KLocalizedString::setApplicationDomain("dikt");
	KAboutData about("dikt", i18n("Dikt"), Dikt::Version,
		i18n("Network Dictionary"), KAboutLicense::BSDL,
		i18n("Copyright 2008-2010 Goran Tal\nAll rights reserved"));
	KAboutData::setApplicationData(about);
	QApplication::setWindowIcon(QIcon::fromTheme("dikt"));

	QCommandLineParser parser;
	about.setupCommandLine(&parser);
	parser.addPositionalArgument("URL", i18n("Location to open"), "[URL]");
	parser.process(app);

	Dikt dikt;
	const KDBusService service(KDBusService::Unique);
	dikt.connect(&service, SIGNAL(activateRequested(const QStringList &, const QString &)),
		SLOT(newInstance(const QStringList &)));
	dikt.newInstance(parser.positionalArguments());
	return app.exec();
}
